/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.List;
import java.util.Set;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.dispenser.LOTRDispenseThrowingAxe;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.projectile.LOTREntityThrowingAxe;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRMaterial;
import lotr.common.recipe.LOTRRecipes;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class LOTRItemThrowingAxe
extends Item {
    private Item.ToolMaterial axeMaterial;

    public LOTRItemThrowingAxe(LOTRMaterial material) {
        this(material.toToolMaterial());
    }

    public LOTRItemThrowingAxe(Item.ToolMaterial material) {
        this.axeMaterial = material;
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
        this.func_77664_n();
        this.func_77637_a(LOTRCreativeTabs.tabCombat);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new LOTRDispenseThrowingAxe());
    }

    public Item.ToolMaterial getAxeMaterial() {
        return this.axeMaterial;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        LOTREntityThrowingAxe axe = new LOTREntityThrowingAxe(world, (EntityLivingBase)entityplayer, itemstack.func_77946_l(), 2.0f);
        axe.setIsCritical(true);
        int fireAspect = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemstack) + LOTREnchantmentHelper.calcFireAspect(itemstack);
        if (fireAspect > 0) {
            axe.func_70015_d(100);
        }
        for (LOTREnchantment ench : LOTREnchantment.allEnchantments) {
            if (!ench.applyToProjectile() || !LOTREnchantmentHelper.hasEnchant(itemstack, ench)) continue;
            LOTREnchantmentHelper.setProjectileEnchantment(axe, ench);
        }
        if (entityplayer.field_71075_bZ.field_75098_d) {
            axe.canBePickedUp = 2;
        }
        world.func_72956_a((Entity)entityplayer, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.25f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)axe);
        }
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        return itemstack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        LOTRPlayerData playerData;
        LOTRFaction pledgeFaction;
        if (player != null && (pledgeFaction = (playerData = LOTRLevelData.getData(player)).getPledgeFaction()) != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_DWARF) {
            int reputation = Math.round(playerData.getAlignment(pledgeFaction));
            String factionName = pledgeFaction.factionName();
            if (reputation < 5000) {
                list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                list.add("");
                list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 5000}));
            } else {
                list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                list.add("");
                list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.dwarfDamage.active", (Object[])new Object[]{"4.0"}));
            }
        }
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }

    public boolean func_82789_a(ItemStack itemstack, ItemStack repairItem) {
        if (LOTRRecipes.checkItemEquals(this.axeMaterial.getRepairItemStack(), repairItem)) {
            return true;
        }
        return super.func_82789_a(itemstack, repairItem);
    }

    public float getRangedDamageMultiplier(ItemStack itemstack, Entity shooter, Entity hit) {
        float damage = this.axeMaterial.func_78000_c() + 4.0f;
        damage = shooter instanceof EntityLivingBase && hit instanceof EntityLivingBase ? (damage = damage + EnchantmentHelper.func_77512_a((EntityLivingBase)((EntityLivingBase)shooter), (EntityLivingBase)((EntityLivingBase)hit))) : (damage = damage + EnchantmentHelper.func_152377_a((ItemStack)itemstack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED));
        return damage * 0.5f;
    }
}

